/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/

package cnrg.itx.gtwy;

import java.io.*;

/**
 * A class that provides information regarding each Gateway line.
 * 
 * @author James Wann
 * @version 1.0a
 */
public class Line implements Serializable
{
	/**
	 * The designated line number of the line.
	 */
	private int lineNumber;
	
	/**
	 * The device handler for the primary channel.
	 */
	private int myChDev;
	
	/**
	 * The device handler for the second channel.  If a channel is already full duplex, this would be the
	 * same as the device handler for the primary channel.
	 */
	private int secondChDev;
	
	/**
	 * The phone number used to reach the line.
	 */
	private String phoneNumber;
	
	/**
	 * true if line is available to make a connection on; false otherwise.
	 */
	private boolean isAvailable;
	
	/**
	 * The line is considered available when an instance is created.
	 * 
	 * @param id the line's id number.
	 * @param chDev the device handler for the primary channel.
	 * @param secChDev the device handler for the second channel.
	 * @param phone the phone number associated with a line.
	 */
	public Line(int id, int chDev, int secChDev, String phone)
	{
		lineNumber = id;
		myChDev = chDev;
		secondChDev = secChDev;
		phoneNumber = new String(phone);
		isAvailable = true;
	}
	
	/**
	 * @return the designated line number of the Gateway line.
	 */
	public int getLineNumber()
	{
		return lineNumber;
	}
	
	/**
	 * @return the primary channel's device handler.
	 */
	protected int getChDev()
	{
		return myChDev;
	}
	
	/**
	 * @return the second channel's device handler.
	 */
	protected int getSecondDev()
	{
		return secondChDev;
	}
	
	/**
	 * @return the extension number of the line.  Used by PBX to make a connection to a phone when the
	 * Gateway calls a telephone.
	 */
	public String getPhoneNumber()
	{
		return phoneNumber;
	}
	
	/**
	 * @return the availability status of the Gateway line for a phone/computer connection.
	 */
	protected boolean getAvailability()
	{
		return isAvailable;
	}
	
	/**
	 * Makes the gateway line available for a connection between a phone and computer.
	 */
	protected void makeAvailable()
	{
		isAvailable = true;
	}
	
	/**
	 * Makes the gateway line unavailable for another connection.
	 */
	protected void makeUnAvailable()
	{
		isAvailable = false;
	}
}